/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWInstruction;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public final class VWDBExecuteParametersTableModel
extends AbstractTableModel {
    private static final int NUM_COLUMNS = 2;
    public static final int COL_ID = 0;
    public static final int COL_PARAMETER = 1;
    private VWAuthPropertyData m_authPropertyData = null;
    private VWInstructionDefinition m_instructionDef = null;
    private Vector m_rowData = null;

    public VWDBExecuteParametersTableModel(VWAuthPropertyData authPropertyData, VWInstructionDefinition instructionDef) {
        try {
            this.m_authPropertyData = authPropertyData;
            this.m_instructionDef = instructionDef;
            this.m_rowData = new Vector();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public String getItemAt(int nRowIndex) {
        String parameter = null;
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        if (nRowIndex < this.m_rowData.size()) {
            parameter = (String)this.m_rowData.elementAt(nRowIndex);
        }
        return parameter;
    }

    public void setInstructionDefinition(VWInstructionDefinition instructionDef) {
        try {
            this.m_instructionDef = instructionDef;
            this.reinitialize();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void up(int nRowIndex) {
        try {
            if (nRowIndex != 0) {
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex - 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex - 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.fireTableDataChanged();
                if (this.m_authPropertyData != null) {
                    this.m_authPropertyData.setDirty();
                    this.updateInstructionDefinition();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void down(int nRowIndex) {
        try {
            if (nRowIndex < this.getRowCount() - 2) {
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex + 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex + 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
                this.fireTableDataChanged();
                if (this.m_authPropertyData != null) {
                    this.m_authPropertyData.setDirty();
                    this.updateInstructionDefinition();
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void deleteItem(int nRowIndex) {
        block3: {
            String parameter = null;
            try {
                parameter = this.getItemAt(nRowIndex);
                if (parameter != null) {
                    this.m_rowData.removeElementAt(nRowIndex);
                    this.fireTableRowsDeleted(nRowIndex, nRowIndex);
                    this.m_authPropertyData.setDirty();
                    this.updateInstructionDefinition();
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                if (this.m_authPropertyData == null) break block3;
                JOptionPane.showMessageDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    public void reinitialize() {
        try {
            this.m_rowData.removeAllElements();
            if (this.m_instructionDef != null) {
                int parametersCount;
                String[] parameters = VWInstruction.DatabaseExecuteInstructionGetParameters(this.m_instructionDef);
                if (parameters != null && (parametersCount = parameters.length) > 0) {
                    for (int i = 0; i < parametersCount; ++i) {
                        this.m_rowData.addElement(parameters[i]);
                    }
                }
                this.fireTableDataChanged();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return String.class;
            }
            case 1: {
                return String.class;
            }
        }
        return null;
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_ID;
            }
            case 1: {
                return VWResource.s_fieldNameStr;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size() + 1;
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        try {
            String parameter = this.getItemAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    return "" + (nRowIndex + 1);
                }
                case 1: {
                    if (parameter == null) break;
                    return parameter;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 1: {
                return true;
            }
        }
        return false;
    }

    public void setValueAt(Object aValue, int nRowIndex, int nColumnIndex) {
        switch (nColumnIndex) {
            case 1: {
                this.onUpdateParameter(aValue, nRowIndex);
            }
        }
    }

    private void onUpdateParameter(Object aValue, int nRowIndex) {
        block5: {
            try {
                String parameter;
                if (aValue != null && aValue instanceof String && (parameter = (String)aValue).length() > 0) {
                    String oldParameter = this.getItemAt(nRowIndex);
                    if (oldParameter != null) {
                        this.m_rowData.setElementAt(parameter, nRowIndex);
                        this.m_authPropertyData.setDirty();
                        this.fireTableCellUpdated(nRowIndex, 0);
                    } else {
                        this.m_rowData.addElement(parameter);
                        this.m_authPropertyData.setDirty();
                        this.fireTableRowsInserted(nRowIndex, nRowIndex + 1);
                    }
                    this.updateInstructionDefinition();
                }
            }
            catch (Exception ex) {
                if (this.m_authPropertyData == null) break block5;
                JOptionPane.showMessageDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), VWResource.s_errorMessageTitle, 0);
            }
        }
    }

    private void updateInstructionDefinition() {
        Object[] parameters = new String[this.m_rowData.size()];
        this.m_rowData.copyInto(parameters);
        VWInstruction.DatabaseExecuteInstructionSetParameters(this.m_instructionDef, (String[])parameters);
    }
}

